<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.1" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:fo="http://www.w3.org/1999/XSL/Format" xmlns:msxsl="urn:schemas-microsoft-com:xslt" xmlns:cif="cif">
    <xsl:param name="xslRootDirectory" select="cif:xslRootDirectory"/>
    <!-- Clearance Report -->
    <xsl:variable name="uniqueClearanceAlignments" select="//ClearancePoints/ClearancePoint[not(@clearanceAlignmentName = preceding-sibling::ClearancePoint/@clearanceAlignmentName )]/@clearanceAlignmentName "/>
    <xsl:template match="/">
        <xsl:variable name="gridOut" select="cif:SetGridOut(number(InRoads/@outputGridScaleFactor))"/>
        <html>
            <head>

                <link rel="stylesheet" type="text/css" href="{$xslRootDirectory}/_Themes/CDOT/theme.css"/>
                <!-- Title displayed in browser Title Bar -->
                <title lang="en">Clearance Report</title>
            </head>
            <body>
                <xsl:apply-templates select="InRoads"/>
            </body>
        </html>
    </xsl:template>
    <xsl:template match="InRoads">
        <center>
            <!-- Report Title -->
			<h1>&#xa0;</h1>                                    
            <h2 lang="en">CDOT Monumentation Clearance Report</h2>
            <p lang="en">
                Report Created: &#xa0;<xsl:value-of select="cif:date()"/><br/>
                Time: &#xa0;<xsl:value-of select="cif:time()"/>
            </p>
        </center>
        <!-- Project Data -->
        <xsl:for-each select="GeometryProject">
            <table class="margin" cellpadding="2" width="90%">
                <tbody>
                    <tr>
                        <th align="right" lang="en">Project:&#xa0; </th>
                        <td align="left" colspan="2"><xsl:value-of select="@name"/></td>
                    </tr>
                    <tr>
                        <th align="right" lang="en">Description:&#xa0; </th>
                        <td align="left" colspan="2"><xsl:value-of select="@description"/></td>
                    </tr>
                    <tr>
                        <th align="right" lang="en">File Name:&#xa0; </th>
                        <td align="left" colspan="2"><xsl:value-of select="@file"/></td>
                    </tr>
                    <tr>
                        <th align="right" lang="en">Last Revised:&#xa0; </th>
                        <td align="left" colspan="2"><xsl:value-of select="concat(@lastRevisedBy, '  ', @lastRevisedDate)"/></td>
                    </tr>
                    <tr>
                        <th align="right" lang="en">Baseline Alignment:&#xa0; </th>
                        <td align="left" colspan="2"><xsl:value-of select="HorizontalAlignment/@name"/></td>
                    </tr>
                </tbody>
            </table>
            <hr />
            <!-- Clearance Point Data -->
            <xsl:for-each select="$uniqueClearanceAlignments">
                <table class="margin" cellpadding="2" width="90%">
                    <thead>
                        <tr>
                            <th align="left" colspan="2" lang="en" valign="bottom"><br/>Clearance Alignment:<br/></th>
                            <td align="left" colspan="4" valign="bottom"><xsl:value-of select="."/></td>
                        </tr>
                            <tr>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Offset<br/>Point</th>
                                <th colspan="3" lang="en">- - - - - - Offset Point - - - - - -</th>
                                <th>&#xa0;</th>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Description</th>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Baseline<br/>Station</th>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Offset</th>
                            </tr>
                            <tr>
                                <th class="underline" lang="en">Northing</th>
                                <th class="underline" lang="en">Easting</th>
                                <th class="underline" lang="en">Elevation</th>
                            </tr>
                    </thead>
                    <tbody>
                        <xsl:for-each select="//ClearancePoint[@clearanceAlignmentName = current()]">
						<xsl:sort select="offsetPoint/@style"/>
						<xsl:sort select="offsetPoint/@name"/>                        
                        <tr>
                            <td align="center">
                                <xsl:value-of select="offsetPoint/@name"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@northing))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@easting))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:elevationFormat(number(offsetPoint/@elevation))"/>
                            </td>
                            <td>&#xa0;</td>
                            <td align="left">
                                <xsl:value-of select="offsetPoint/@description"/>
                            </td>                            
                            <td align="right">
                                <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                            </td>
                            <td align="right">
                                <xsl:value-of select="cif:distanceFormat(number(@firstOffset), $xslDistancePrecision)"/>
                            </td>
                        </tr>
                        </xsl:for-each>
                    </tbody>
                </table>
            </xsl:for-each>
            <!-- Clearance Points from Cogo Data -->
            <xsl:if test="//ClearancePoint[@origin = 'point']">
                <xsl:for-each select="//ClearancePoints">
                    <table class="margin" cellpadding="2" width="90%">
                        <thead>
                            <tr>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Offset<br/>Point</th>
                                <th colspan="3" lang="en">- - - - - - Offset Point - - - - - -</th>
                                <th>&#xa0;</th>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Description</th>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Baseline<br/>Station</th>
                                <th class="underline" lang="en" rowspan="2" valign="bottom">Offset</th>
                            </tr>
                            <tr>
                                <th class="underline" lang="en">Northing</th>
                                <th class="underline" lang="en">Easting</th>
                                <th class="underline" lang="en">Elevation</th>
                            </tr>
                        </thead>
                        <tbody>
                            <xsl:for-each select="//ClearancePoint[@origin = 'point']">
							<xsl:sort select="offsetPoint/@style"/>
							<xsl:sort select="offsetPoint/@name"/>
                            <tr>
                                <td align="center">
                                    <xsl:value-of select="offsetPoint/@name"/>
                                </td>
                                <td align="right">
                                    <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@northing))"/>
                                </td>
                                <td align="right">
                                    <xsl:value-of select="cif:ordinateFormat(number(offsetPoint/@easting))"/>
                                </td>
                                <td align="right">
                                    <xsl:value-of select="cif:elevationFormat(number(offsetPoint/@elevation))"/>
                                </td>
                                <td>&#xa0;</td>
                                <td align="left">
                                    <xsl:value-of select="offsetPoint/@description"/>
                                </td>
                                <td align="right">
                                    <xsl:value-of select="cif:stationFormat(number(centerLinePoint/point/station/@externalStation), string(centerLinePoint/point/station/@externalStationName))"/>
                                </td>
                                <td align="right">
                                    <xsl:value-of select="cif:distanceFormat(number(@firstOffset), $xslDistancePrecision)"/>
                                </td>
                            </tr>
                            </xsl:for-each>
                        </tbody>
                    </table>
                </xsl:for-each>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>
</xsl:stylesheet>
